package cn.com.duiba.supplier.center.api.enums;

import java.util.Objects;

/**
 * @author yangyukang
 */
public enum DuiBaSupplyOrdersPushBizTypeEnum {

    SUPPLY_ORDER_STATUS(1, "采购单状态推送"),
    COUPON_LINK_DRAW_STATUS(2, "立减金领取记录推送"),
    COUPON_VERIFICATION_NOT_DUIBA(3, "立减金核销推送-兑吧制券-三方发券"),
    COUPON_VERIFICATION_BY_DUIBA(4, "立减金核销推送-兑吧制券-兑吧发券"),
    ;

    private Integer code;
    private String desc;

    DuiBaSupplyOrdersPushBizTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * 根据code获取枚举对象
     * @param code
     * @return
     */
    public static DuiBaSupplyOrdersPushBizTypeEnum ofValue(int code){
        for (DuiBaSupplyOrdersPushBizTypeEnum type : values()){
            if(Objects.equals(code,type.getCode())){
                return type;
            }
        }
        throw new UnsupportedOperationException("不支持的类型");
    }
}
