package cn.com.duiba.supplier.center.api.remoteservice.quanyi;

import cn.com.duiba.biz.tool.duiba.dto.page.Page;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.supplier.center.api.dto.OrderListVO;
import cn.com.duiba.supplier.center.api.dto.UpdateLogisticsDto;
import cn.com.duiba.supplier.center.api.dto.quanyi.OrderResultDto;
import cn.com.duiba.supplier.center.api.dto.quanyi.SendData;
import cn.com.duiba.supplier.center.api.request.order.QueryOrderListRequest;

import java.util.List;

@AdvancedFeignClient
public interface RemoteQuanYiSupplierService {

    /**
     * 分页查询采购单
     */
    Page<OrderListVO> findPage(QueryOrderListRequest request);

    /**
     * 商品单笔发货
     * @param supplierId
     * @param sendData
     * @return
     * @throws BizException
     */
    Boolean goodsManualDelivery(Long supplierId, SendData sendData) throws BizException;

    /**
     * 商品物流信息修改
     * @param updateLogisticsDto
     * @return
     * @throws BizException
     */
    int updateLogisticsInfo(UpdateLogisticsDto updateLogisticsDto, Long supplierId) throws BizException;

    /**
     * 批量发货
     * @param supplierId 供应商id
     * @param list 发货列表
     * @return batchId
     * @throws BizException
     */
    String batchSend(Long supplierId, List<SendData> list) throws BizException;

    /**
     * 发货状态结果查询
     * @return
     * @throws BizException
     */
    OrderResultDto querySendResult(Long supplierId, String batchId) throws BizException;
}
