package cn.com.duiba.supplier.center.api.enums;

/**
 * @program: supplier-center
 * @description: 发货单订单状态状态枚举
 * @author: Simba
 * @create: 2018-11-30 11:10
 **/
public enum SupplyDeliveryStatusEnum {

    WAIT_SEND(1, "待发货"),

    AFTER_SEND(2, "已发货"),

    SUCCESS(3, "发货单完结-交易成功"),

    FAIL(4, "发货单完结-交易失败")
    ;

    private Integer code;

    private String desc;

    SupplyDeliveryStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

//    CREATE(0, "初始化-创建"),
//
//    WAIT_SEND(1, "待发货"),
//
//    AFTER_SEND(2, "已发货"),
//
//    SUCCESS(3, "发货单完结-交易成功"),
//
//    FAIL(4, "发货单完结-交易失败"),
//
//    EXCEPTION(5, "兑换异常"),
            ;
}