package cn.com.duiba.supplier.center.api.remoteservice.item;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.boot.netflix.feign.hystrix.FeignHystrixCommand;
import cn.com.duiba.boot.netflix.feign.hystrix.FeignHystrixProperty;
import cn.com.duiba.boot.netflix.feign.hystrix.conf.HystrixPropertiesManager;
import cn.com.duiba.supplier.center.api.dto.item.ItemValidResult;

/**
 * 针对手机端调用，隔离容器线程池，避免网络问题导致容器线程池占满
 * Created by xutao on 2019/6/13.
 */
@AdvancedFeignClient
public interface RemoteThirdItemService {
    /**
     *
     * @param jdSkuId
     * @param duibaAddress
     * @return
     * @throws BizException
     */
    @FeignHystrixCommand(threadPoolKey = "jd-http-pool")
    @FeignHystrixProperty(name= HystrixPropertiesManager.CORE_SIZE, value="50")
    ItemValidResult checkValid(Long duibaSkuId, String jdSkuId, String duibaAddress, Integer quantity, int supplierId) throws BizException;

}
