package cn.com.duiba.supplier.center.api.remoteservice.supply;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.supplier.center.api.dto.supplier.SupplyOrderRetryDto;
import cn.com.duiba.supplier.center.api.params.SupplyOrderInfoParam;
import cn.com.duiba.supplier.center.api.params.SupplyOrderPageParam;

import java.util.List;


/**
 * 采购订单重试表service
 * @author lyj
 * @desc 具体是否支持参考定时任务业务逻辑
 */
@AdvancedFeignClient
public interface RemoteSupplyOrderRetryService {


    /**
     * 插入数据
     */
    Long insert(SupplyOrderRetryDto supplyOrderRetryEntity);

    /**
     * 查询订单数据
     * @param param 查询请求参数
     * @return 订单结果
     */
    SupplyOrderRetryDto selectOrder(SupplyOrderInfoParam param);

    /**
     * 分页查询数据
     * @param param 请求参数
     * @return 分页数据
     */
    List<SupplyOrderRetryDto> selectPage(SupplyOrderPageParam param);

    /**
     * 查询分页数量
     * @param param 请求参数
     * @return 分页数据
     */
    Long selectCount(SupplyOrderPageParam param);

    /**
     * 根据ID更新订单状态
     * @param entity 订单信息
     * @return 结果
     */
    int updateById(SupplyOrderRetryDto entity);

}
