package cn.com.duiba.supplier.channel.service.api.dto.request.warnorders;

import lombok.Data;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

/**
 * 渠道告警表
 * @author mybatis generator 
 * @date 2023-12-12
 */
@Data
@ToString(callSuper = true)
public class ChannelWarnOrdersSearchParam implements Serializable {

    private static final long serialVersionUID = 17023738095449251L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;

    /**
     * 权益渠道
     */
    private Byte channelType;

    /**
     * 业务方类型
     */
    private Byte bizType;

    /**
     * 业务方唯一单号
     */
    private String bizNo;

    /**
     * 最新的调用第三方的唯一单号，生成规则：结合biz_type+biz_no+retry_type+retry_count+第三方要求
     */
    private String outBizNo;

    /**
     * 失败错误吗
     */
    private String errorCode;

    /**
     * 失败错误原因
     */
    private String errorMsg;

    /**
     * 当前页
     */
    private Integer pageIndex = 1;

    /**
     * 页数量
     */
    private Integer pageSize = 20;

    public Integer getOffset() {
        if (Objects.nonNull(pageIndex) && Objects.nonNull(pageSize)) {
            return (pageIndex - 1) * pageSize;
        }
        return null;
    }

    /**
     * 开始时间
     */
    private Date startTime;

    /**
     * 结束时间
     */
    private Date endTime;


}