package cn.com.duiba.supplier.channel.service.api.remoteservice.warnorders;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.supplier.channel.service.api.dto.request.warnorders.ChannelWarnOrdersSearchParam;
import cn.com.duiba.supplier.channel.service.api.dto.response.warnorders.ChannelWarnOrdersDto;

import java.util.List;

/**
 * 渠道告警表
 * @author kjj mybatis generator 
 * @date 2023-12-12
 */
@AdvancedFeignClient
public interface RemoteChannelWarnOrdersService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 渠道告警集合
     */
    List<ChannelWarnOrdersDto> selectPage(ChannelWarnOrdersSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(ChannelWarnOrdersSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 渠道告警
     */
    ChannelWarnOrdersDto selectById(Long id);

    /**
     * 新增
     * @param dto 渠道告警
     * @return 执行结果
     */
    int insert(ChannelWarnOrdersDto dto);

    /**
     * 更新
     * @param dto 渠道告警
     * @return 影响行数
     */
    int update(ChannelWarnOrdersDto dto);
}