package cn.com.duiba.supplier.channel.service.api.enums.order;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 渠道类型
 * @author lizhi
 * @date 2023/4/10 11:38 AM
 */
@Getter
@AllArgsConstructor
public enum ChannelTypeEnum {
    ALI_PAY_COUPON(1, "支付宝立减金"),
    TRANSFER_BATCHES(2, "微信商家转账到零钱"),
    WX_FAVOR(3, "微信发放代金券"),
    JI_GAO_WX_MKT_TRANS(4, "继皋直充-企业付款到零钱"),
    I_QI_YI_ZC(5, "爱奇艺-直充"),
    ALIPAY_COUNT_COINS(6, "支付宝数币红包"),
    CCB_PAY_COUNT_COINS(7, "建行数币红包"),
    MEI_TUAN_STORE_YIN_SHENG_SHU_HUI(8, "美团到店-银盛数惠"),
    ;

    /**
     * 类型
     */
    private final Integer type;

    /**
     * 描述
     */
    private final String desc;
}
