package cn.com.duiba.supplier.channel.service.api.enums.channel;

import cn.com.duiba.boot.exception.BizException;
import lombok.AllArgsConstructor;
import lombok.Getter;

@Getter
@AllArgsConstructor
public enum QiMaiCodeEnum {

    SUCCESS("0000", "成功"),
    SUCCESS_TWO("0", "成功"),
    SYSTEM_ERROR("1500", "接口异常"),
    INTERFACE_VERSION_NOT_EXIST("1501", "指定的接口版本不存在"),
    ADDRESS_NOT_EXIST("1502", "非法请求，没有按照规范填写接口地址"),
    ADDRESS_ERROR_CONTENT("1503", "非法请求，请求地址有非法内容"),
    NOT_NAME("1504", "请求方法存在不允许的名称"),
    INTERFACE_NOT_EXIST("1505", "接口不存在"),
    APP_NOT_EXIST("4001", "应用不存在"),
    APP_NOT_EXIST_TWO("110006", "应用不存在"),
    IP_ERROR("4002", "未授权IP"),
    SIGN_ERROR("4003", "非法请求，签名校验失败"),
    PERMISSION_NOT_EXIST("4005", "授权不存在"),
    PARAM_ERROR("4006", "非法请求，参数缺失"),
    APP_CLOSE("4007", "应用已关闭，请联系客服"),
    ERROR("999999", "系统异常"),

    ;

    /**
     * 结果码
     */
    @Getter
    private final String code;

    /**
     * 描述
     */
    private final String remark;

    public static QiMaiCodeEnum getByCode(String code) throws BizException {
        for (QiMaiCodeEnum value : values()) {
            if (value.getCode().equals(code)) {
                return value;
            }
        }
        throw new BizException("未找到对应的枚举值");
    }
}
