package cn.com.duiba.supplier.channel.service.api.dto.request.wx.favor;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import java.io.Serializable;

/**
 * 微信立减金发放
 * @author lizhi
 * @date 2023/5/17 4:54 PM
 */
@Data
public class WxFavorUserCouponsReq implements Serializable {
    private static final long serialVersionUID = 841008421510428339L;

    /**
     * 商户ID
     */
    @NotBlank(message = "mchId must not be null")
    @Size(max = 32, message = "mchId不能超过32")
    private String mchId;

    /**
     * 批次号		 
     */
    @NotBlank(message = "stockId must not be null")
    @Size(max = 20, message = "stockId不能超过20")
    private String stockId;

    /**
     * 商户单据号		 
     */
    @NotBlank(message = "outRequestNo must not be null")
    @Size(max = 128, message = "outRequestNo不能超过128")
    private String outRequestNo;

    /**
     * 公众账号ID		 
     */
    @NotBlank(message = "appId must not be null")
    @Size(max = 128, message = "appId不能超过128")
    private String appId;

    /**
     * 创建批次的商户号	 
     */
    @NotBlank(message = "stockCreatorMchId must not be null")
    @Size(max = 20, message = "stockCreatorMchId不能超过20")
    private String stockCreatorMchId;

    /**
     * 收款用户openid
     */
    @NotBlank(message = "openId must not be null")
    @Size(max = 64, message = "openId不能超过64")
    private String openId;

    /**
     * 指定面额发券，面额
     * 说明：定面额发券场景，券面额，其他场景不需要填，单位：分。 
     * 校验规则：仅在发券时指定面额及门槛的场景才生效，常规发券场景请勿传入该信息。
     * 选填
     */
    private Integer couponValue;

    /**
     * 指定面额发券，券门槛
     * 说明：指定面额发券批次门槛，其他场景不需要，单位：分。 
     * 校验规则：仅在发券时指定面额及门槛的场景才生效，常规发券场景请勿传入该信息。
     * 选填
     */
    private Integer couponMinimum;

    /**
     * 发放成功后，是否需要查询优惠券信息（失效时间等）
     */
    private boolean needQueryCoupon;
}
