package cn.com.duiba.supplier.channel.service.api.enums.channel;

import cn.com.duiba.boot.exception.BizException;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 优酷错误码枚举
 *
 * @author wangguanhua
 */
@Getter
@AllArgsConstructor
public enum YoukuErrorCodeEnum {

    /**
     * 1. 订单查询接口返回代码 0 代表订单不在
     * 2. 商家活动充值数量查询接口返回代码 0 代表库存有异常或错误
     * 3. 订单充值接口返回代码 0 代表创建订单有未定义的错误
     */
    UNKNOWN_ERROR(0, "未知错误"),
    SUCCESS(1, "请求成功"),
    INVALID_PARAMETER(-100, "参数有误"),
    SIGNATURE_ERROR(-101, "签名错误"),
    SECRET_ERROR(-105, "商家私钥错误"),
    ACTIVITY_ERROR(-1401, "活动信息有误"),
    ACTIVITY_TIME_ERROR(-1402, "活动时间范围有误"),
    ACTIVITY_NOT_ENABLE(-1403, "活动状态未开启"),
    REGISTER_FAIL(-1409, "尝试为未注册用户注册失败"),
    ACTIVITY_UPPER_LIMIT(-1411, "活动数量达到上限");

    private final Integer code;
    private final String description;

    public static YoukuErrorCodeEnum getByCode(Integer code) throws BizException {
        for (YoukuErrorCodeEnum value : values()) {
            if (value.getCode().equals(code)) {
                return value;
            }
        }
        throw new BizException("未找到对应的枚举值");
    }
}
