package cn.com.duiba.supplier.channel.service.api.enums.channel;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author: LuHui
 * @date: 2024/2/19 17:26
 * @description:
 */
@Getter
@AllArgsConstructor
public enum NaiXueCouponCodeEnum {

    /**
     * 1:未使用 2:已使用(已核销) 3:已过期 4:已回收
     */
    NOT_USE(1, "未使用"),
    USED(2, "已使用(已核销)"),
    EXPIRED(3, "已过期"),
    RECYCLE(4, "已回收"),
    ;


    private static final Map<Integer, NaiXueCouponCodeEnum> codeEnumMap = Arrays.stream(values())
            .collect(Collectors.toMap(NaiXueCouponCodeEnum::getCode, Function.identity(), (v1, v2) -> v1));

    public static NaiXueCouponCodeEnum getByCode(Integer code) {
        return codeEnumMap.get(code);
    }

    private final Integer code;

    private final String desc;
}
