package cn.com.duiba.supplier.channel.service.api.remoteservice.kuaidi100;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.supplier.channel.service.api.dto.request.kuaidi100.Kuaidi100SubscribeReq;
import cn.com.duiba.supplier.channel.service.api.dto.response.express.ExpressTrackInfoDto;

/**
 * remote kuaidi100 service
 *
 * @author wangguanhua
 */
@AdvancedFeignClient
public interface RemoteKuaidi100Service {

    /**
     * 订阅物流信息
     *
     * @param kuaidi100SubscribeReq kuaidi100 subscribe req
     */
    void subscribe(Kuaidi100SubscribeReq kuaidi100SubscribeReq);

    /**
     * 更新物流信息
     *
     * @param expressInfo express info
     * @return boolean
     */
    boolean updateExpressInfo(String expressInfo);

    /**
     * 获取物流及轨迹相关信息
     *
     * @param expressNo express no
     * @return {@link ExpressTrackInfoDto}
     */
    ExpressTrackInfoDto getExpressTrackInfoDto(String expressNo);

    /**
     * 签名校验
     *
     * @param param param
     * @param sign  sign
     * @return boolean
     */
    boolean verifySign(String param, String sign);

}
