package cn.com.duiba.supplier.channel.service.api.dto.response.wx.favor;

import lombok.Data;

import java.io.Serializable;

/**
 * @author lizhi
 * @date 2023/12/27 13:53
 */
@Data
public class WxFavorNotifyResp implements Serializable {
    private static final long serialVersionUID = -2814657104112682358L;

    /**
     * 	批次创建方商户号。
     */
    private String stockCreatorMchId;

    /**
     * 微信为每个代金券批次分配的唯一id。
     */
    private String stockId;

    /**
     * 微信为代金券唯一分配的id。
     */
    private String couponId;

    /**
     * 	单品优惠特定信息。
     */
    private WxFavorSingleItemDiscountOffDto singleItemDiscountOff;

    /**
     * 减至优惠限定字段，仅减至优惠场景有返回。
     */
    private WxFavorDiscountToDto discountTo;

    /**
     * 代金券名称
     */
    private String couponName;

    /**
     * 代金券状态：
     * SENDED：可用(核销通知中不会头这个状态)
     * USED：已实扣
     * EXPIRED：已过期(核销通知中不会头这个状态)
     */
    private String status;

    /**
     * 代金券描述说明字段。
     */
    private String description;

    /**
     * 领券时间
     */
    private String createTime;

    /**
     * 类型
     * NORMAL：满减券
     * CUT_TO：减至券
     */
    private String couponType;

    /**
     *是否无资金流
     * true：是
     * false：否
     */
    private boolean noCash;

    /**
     * 可用开始时间
     */
    private String availableBeginTime;
    
    /**
     * 可用结束时间
     */
    private String availableEndTime;


    /**
     * 是否单品优惠
     */
    private boolean singleItem;

    /**
     * 普通满减券面额、门槛信息。
     */
    private WxFavorFixedNormalCouponDto normalCouponInformation;

    /**
     * 已实扣代金券信息。
     */
    private WxFavorConsumeInformationDto consumeInformation;
}
