package cn.com.duiba.supplier.channel.service.api.dto.request.jigao;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 继皋直充-企业付款到零钱
 * @author lizhi
 * @date 2023/6/20 3:28 PM
 */
@Data
public class JiGaoWetPayMktTransReq implements Serializable {
    
    private static final long serialVersionUID = 49874502047368800L;

    /**
     * 用户微信openId
     * 最大32位
     * 必填
     */
    @NotBlank(message = "openId不能为空")
    private String openId;

    /**
     * 是否有发票：0无票、1专票、2零票，默认为1
     * 必填
     */
    private String voiceFlag = "1";

    /**
     * 金额，单位元
     */
    @NotBlank(message = "金额不能为空")
    private String facePrice;

    /**
     * 透传参数，最大200位，用户上送时，将在回调及订单查询时原内容返回
     * 选填
     */
    private String attach;

    /**
     * 异步通知地址
     * 必填
     */
    @NotBlank(message = "通知地址不能为空")
    private String notifyUrl;

    /**
     * 微信公众账号ID
     * 必填
     */
    @NotBlank(message = "appId不能为空")
    private String appId;

    /**
     * 微信的转账备注
     * 必填
     */
    @NotBlank(message = "转账备注不能为空")
    private String remark;

    /**
     * 用户真实姓名(选填，若传入用户真实姓名，将与微信实名认证的姓名进行校验，只有一致时才能转账到用户零钱)
     */
    private String userName;
}
