package cn.com.duiba.supplier.channel.service.api.enums.channel;

import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.extern.slf4j.Slf4j;

import java.util.Objects;

/**
 * @author: LuHui
 * @date: 2024/3/21 10:13
 * @description:
 */
@Getter
@AllArgsConstructor
public enum HangLvZongHengCodeEnum {

    SUCCESS("0", "成功"),
    CALLBACK_SUCCESS("-1370431", "成功"),
    E_1370358("-1370358", "订单已存在"),
    E_10003("1000", "时间戳不合法"),
    E_11001("11001", "ip地址为空"),
    E_11002("11002", "appid账号为空"),
    E_11003("11003", "时间戳为空"),
    E_11004("11004", "版本号为空"),
    E_11005("11005", "请求的唯一标识为空"),
    E_11006("11006", "类型为空"),
    E_11007("11007", "签名是空"),
    E_11008("11008", "accessToken是空"),
    E_11009("11009", "账户不存在"),
    E_11010("11010", "类型不支持"),
    E_11011("11011", "签名错误"),
    E_11012("11012", "appid账号不存在"),
    E_11013("11013", "ip没在航旅纵横白名单中"),
    E_11014("11014", "ip白名单没有配置"),
    E_11015("11015", "角色id不存在"),
    E_11016("11016", "资源id不存在"),
    E_11017("11017", "资源url没有匹配到"),
    E_11018("11018", "app的信息不存在"),
    E_11019("11019", "appid过期了"),
    E_11028("11028", "付费资源鉴权失败"),
    E_1375007("1375007", "当前请求在处理中，请勿重复调用"),
    E_137500("137500", "订单已存在"),
    E_1375009("1375009", "未获取到库存信息"),
    E_1375002("1375002", "生成权益二维码失败"),
    E_1375004("1375004", "获取账户余额失败"),
    E_1375005("1375005", "获取账户套餐库存失败"),
    E_1375006("1375006", "获取账户套餐库存失败"),
    E_1375003("1375003", "查询使用情况失败"),
    E_1375001("1375001", "提交订单申请失败"),
    E_1375011("1375011", "库存不足"),
    E_1375012("1375012", "账户信息不存在"),
    E_1375013("1375013", "创建订单失败"),
    E_1375014("1375014", "订单不存在"),
    E_1375015("1375015", "激活套餐失败"),
    E_1375020("1375020", "套餐不支持退单"),
    E_1375021("1375021", "订单状态不支持退单（如用户已使用)"),
    E_1375022("1375022", "未查询订单相关信息失败"),
    E_1375024("1375024", "未获取到商户信息"),
    E_1375025("1375025", "系统异常，请稍后重试"),
    E_1375027("1375027", "参数校验失败"),
    E_1375033("1375033", "退单失败"),
    E_1375034("1375034", "查询贵宾厅列表失败"),
    E_1375035("1375035", "查询餐饮网点列表失败"),
    E_1375036("1375036", "查询快速安检列表失败"),

    ;


    private final String code;

    private final String desc;

    public static HangLvZongHengCodeEnum getByCode(String code) {
        for (HangLvZongHengCodeEnum codeEnum : HangLvZongHengCodeEnum.values()) {
            if (Objects.equals(codeEnum.getCode(), code)) {
                return codeEnum;
            }
        }
        return null;
    }
}
