package cn.com.duiba.supplier.channel.service.api.enums.channel;


import lombok.AllArgsConstructor;
import lombok.Getter;

@Getter
@AllArgsConstructor
public enum MeiTuanPayCouponErrorStatusEnum {
    FAIL_100000(100000, "请求参数错误"),
    FAIL_100001(100001, "发券异常【连接失败/超时错误/...】"),
    FAIL_100002(100002, "非美团用户待发券【此错误码标识给该用户保留发券资格，待用户注册美团后自动发放此次请求批次中对应的支付券】"),
    FAIL_100003(100003, "非美团认证商户"),
    FAIL_100004(100004, "签名失败"),
    FAIL_100005(100005, "用户限频(请求频率过高)"),
    FAIL_100006(100006, "批次已下线/过期"),
    FAIL_100007(100007, "用户领取受限"),
    FAIL_100008(100008, "券批次不存在，请和美团运营联系"),
    FAIL_100009(100009, "发放张数大于剩余库存"),
    FAIL_100010(100010, "单次请求领取张数上限40"),
    FAIL_100011(100011, "该流水号无对应的发券记录"),
    FAIL_100022(100022, "回调地址配置异常"),
    FAIL_100024(100024, "非美团用户不发券"),

    ;
    /**
     * 状态码
     */
    private final Integer code;
    /**
     * 描述
     */
    private final String desc;

    //根据状态码获取枚举
    public static MeiTuanPayCouponErrorStatusEnum getByCode(Integer code) {
        for (MeiTuanPayCouponErrorStatusEnum statusEnum : values()) {
            if (statusEnum.code.equals(code)) {
                return statusEnum;
            }
        }
        return null;
    }
}
