package cn.com.duiba.supplier.channel.service.api.enums.channel;

import lombok.Getter;
import lombok.RequiredArgsConstructor;

import java.util.Arrays;
import java.util.List;

@RequiredArgsConstructor
@Getter
public enum DouYinPayCouponCodeEnum {


    //========================400=====================
    PARAM_ERROR("PARAM_ERROR", "参数错误"),

    //批次查询
    STOCK_STATUS_ERROR("STOCK_STATUS_ERROR", "券批次状态异常"),
    ACTIVITY_NOT_EXISTS("ACTIVITY_NOT_EXISTS", "活动id不合法"),

    //发券
    COUPON_NOT_EXIST("COUPON_NOT_EXIST", "券不存在"),
    USER_NOT_EXISTS("USER_NOT_EXISTS", "用户id不合法"),
    STOCK_NOT_ENOUGH("STOCK_NOT_ENOUGH", "券批次库存不足"),
    USER_STOCK_LIMIT("USER_STOCK_LIMIT", "用户发券达到限额"),
    COUPON_FAIL_ERROR("COUPON_FAIL_ERROR", "发券失败"),




    //==========================401=====================
    SIGN_ERROR("SIGN_ERROR", "签名错误"),
    ROUTE_NOT_EXIST("ROUTE_NOT_EXIST", "请求路由不存在"),
    BAD_CONNECT("BAD_CONNECT","连接错误"),
    SERVICE_UNAVAILABLE("SERVICE_UNAVAILABLE","服务不可用"),
    NOT_AUTH("NOT_AUTH","商户无权限"),
    REQUEST_FORBIDDEN("REQUEST_FORBIDDEN","禁止访问"),



    //=========================403======================
    //批次查询
    MERCHANT_NO_AUTH("MERCHANT_NO_AUTH", "商户无活动发券权限"),

    //发券
    RISK_CONTROL_INTERCEPTION("RISK_CONTROL_INTERCEPTION", "风控拦截"),
    USER_NO_AUTH("USER_NO_AUTH", "用户无操作权限"),


    //=========================404======================
    //批次查询
    ACTIVITY_NOT_FOUND("ACTIVITY_NOT_FOUND", "活动不存在"),

    //发券
    USER_NOT_FOUND("USER_NOT_FOUND", "用户不存在"),



    //======================429=========================
    FREQUENCY_LIMITED("FREQUENCY_LIMITED", "频率超频"),


    //========================500=========================
    SYSTEM_ERROR("SYSTEM_ERROR", "SYSTEM_ERROR"),

    ;

    /**
     * 错误码
     */
    private final String code;

    /**
     * 描述
     */
    private final String message;


    public static List<String> get400Codes() {
        return Arrays.asList(PARAM_ERROR.getCode(), STOCK_STATUS_ERROR.getCode(),
                ACTIVITY_NOT_EXISTS.getCode(), USER_NOT_EXISTS.getCode(),
                STOCK_NOT_ENOUGH.getCode(), USER_STOCK_LIMIT.getCode(),
                COUPON_FAIL_ERROR.getCode(), COUPON_NOT_EXIST.getCode());
    }

    public static List<String> get401Codes() {
        return Arrays.asList(SIGN_ERROR.getCode(), ROUTE_NOT_EXIST.getCode(),
                BAD_CONNECT.getCode(), SERVICE_UNAVAILABLE.getCode(),
                NOT_AUTH.getCode(), REQUEST_FORBIDDEN.getCode());
    }

    public static List<String> get403Codes() {
        return Arrays.asList(MERCHANT_NO_AUTH.getCode(), USER_NO_AUTH.getCode(),RISK_CONTROL_INTERCEPTION.getCode());
    }
    public static List<String> get404Codes() {
        return Arrays.asList(ACTIVITY_NOT_FOUND.getCode(), USER_NOT_FOUND.getCode());
    }
    public static List<String> get429Codes() {
        return Arrays.asList(FREQUENCY_LIMITED.getCode());
    }
    public static List<String> get500Codes() {
        return Arrays.asList(SYSTEM_ERROR.getCode());
    }
}
