package cn.com.duiba.supplier.channel.service.api.enums.order;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 渠道类型
 * @author lizhi
 * @date 2023/4/10 11:38 AM
 */
@Getter
@AllArgsConstructor
public enum ChannelTypeEnum {
    ALI_PAY_COUPON(1, "支付宝立减金"),
    TRANSFER_BATCHES(2, "微信商家转账到零钱"),
    WX_FAVOR(3, "微信发放代金券"),
    WX_TRANSFER_JI_GAO(4, "继皋直充-微信到零钱"),
    I_QI_YI_ZC(5, "爱奇艺-直充"),
    ALIPAY_COUNT_COINS(6, "支付宝数币红包"),
    CCB_PAY_COUNT_COINS(7, "建行数币红包"),
    MEI_TUAN_STORE_YIN_SHENG_SHU_HUI(8, "美团到店-银盛数惠"),
    YI_AN_YOU_KU(9, "优酷会员-易安"),
    TE_LAI_DIAN_COUPON_ZC(10, "特来电卡劵直充"),
    TUAN_YOU_YI_AN(11,  "团油-易安"),
    CLOUD_360_VIP_ZC(12, "360安全云盘会员"),
    HUA_FEI_CHONG_DA(13,"无票话费-充达"),
    BA_WANG_CHA_JI_QIMAI(14, "霸王茶姬-企迈"),
    WX_TRANSFER_KA_CHI(15, "微信到零钱-卡池"),
    MI_GU_VIDEO_VIP_TE_ZHEN(16, "咪咕视频会员-特祯"),
    QQ_VIP_TE_ZHEN(17, "QQ会员-特祯"),
    TEN_XUN_QQ_MUSIC_VIP_TE_ZHEN(18, "腾讯QQ音乐会员-特祯"),
    DIDI_CAR_COUPON_TE_ZHEN(19, "滴滴快车代金劵-特祯"),
    RUI_XING_COFFE_ZC_TE_ZHEN(20, "瑞希咖啡直充-特祯"),
    Q_B_DIAN_DIAN(21, "Q币-点点"),
    NAI_XUE_ZC(22, "奈雪-直充"),
    WANG_YI_YUN_VIP_DING_XIN(24, "网易云音乐会员-鼎信"),
    BAI_DU_CLOUD_VIP_DING_XIN(25, "百度网盘会员-鼎信"),
    I_QI_YI_DIAN_DIAN(26, "爱奇艺-点点"),
    TEN_XUN_VIDEO_VIP_DING_XIN(27, "腾讯视频会员-鼎信"),
    FEI_HAN_BI_LI_BI_LI_VIP(28, "哔哩哔哩会员-飞翰"),
    YI_PAI_XI_MA_LA_YA_VIP(29, "喜马拉雅会员-易派"),
    FU_LU_MANG_GUO_TV_VIP(30, "芒果TV会员-福禄"),
    WX_RED_PACKET_JI_GAO(31, "继皋直充-微信红包"),
    TENCENT_VIDEO_VIP_DIAN_DIAN(33, "腾讯视频-点点"),
    J_D_E_CARD(32, "京东E卡"),
    HANG_LV_ZONG_HENG_ZC(35, "航旅纵横直充"),
    WX_TRANSFER_SHEN_BIAN_YUN(34, "身边云-微信零钱"),
    HUA_FEI_KA_CHI(36,"有票话费-卡池"),
    YOUKU_VIP_ZC(37, "优酷会员-直充"),

    YOUKU_YIPAI(39, "优酷会员-易派"),
    CNPC_ANYI(40, "中石油-安怡"),
    SINOPEC_ANYI(41, "中石化-安怡"),
    HONG_EN_ZC(42,"洪恩直充"),
    TUAN_YOU(43, "团油直充"),
    MEI_TUAN_COUPON_YI_PAI(44, "美团代金券-易派"),
    TEN_XUN_VIDEO_VIP_FU_LU(45, "腾讯视频会员-福禄"),
    TEN_XUN_QQ_MUSIC_VIP_FU_LU(46, "腾讯QQ音乐会员-福禄"),

    WX_MORE_TRANSFER_SHEN_BIAN_YUN(47,"身边云-微信大额转账"),
    BANK_MORE_TRANSFER_SHEN_BIAN_YUN(48,"身边云-银行卡大额转账"),
    CNPC_SHENGMA(49, "中石油-盛马"),
    SINOPEC_SHENGMA(50, "中石化-盛马"),

    DING_XING_RUI_XING_COFFEE_COUPON(51,"鼎信-瑞辛代金券"),
    TE_ZHEN_BI_LI_BI_LI_VIP(52,"特祯-哔哩哔哩会员"),
    MI_XUE_BING_CHENG_TE_ZHEN(53, "蜜雪冰城-特祯"),
    TU_HU_COUPON_PU_MAI(54, "途虎洗车劵-普麦"),
    GAO_DE_COUPON_PU_MAI(55, "高德打车劵-普麦"),
    WPS_VIP_COUPON_PU_MAI(56, "wps会员-普麦"),
    MANG_GUO_QUAN_PING_VIP_PU_MAI(57, "芒果全屏影视会员-普麦"),
    MANG_GUO_YI_DONG_VIP_PU_MAI(58, "芒果移动影视会员-普麦"),
    I_QI_YI_PU_MAI(59, "爱奇艺会员-普麦"),
    TEN_XUN_QQ_MUSIC_VIP_DING_XIN(60, "腾讯QQ音乐会员-鼎信"),
    DOU_YIN_COUPON_CHENG_YI(61, "抖音团购券-骋翼"),

    HUA_FEI_SU_XI(62,"话费-苏西"),
    GU_MING_COUPON(63,"古茗代金券"),
    RUI_XING_COFFE_ZC_QING_TIAN(64,"瑞幸咖啡-晴天"),
    QQ_READ_VIP_ZC_QING_TIAN(65,"QQ阅读会员-晴天"),
    WANG_YI_YUN_VIP_ZC_QING_TIAN(66,"网易云-晴天"),
    QQ_VIP_ZC_QING_TIAN(67,"QQ会员-晴天"),
    DIDI_QJ_RIDING_ZC_QING_TIAN(68,"滴滴青桔骑车卡-晴天"),
    WANG_YI_YUN_VIP_ZC_YI_LI(69,"网易云音乐月卡-翌理"),
    WANG_YI_YUN_VIP_ZC_FENG_ZHU_SHOU(70,"网易云音乐月卡-蜂助手"),
    MEI_TUAN_COUPON_PU_MAI(71, "美团代金券-普麦"),
    MEI_TUAN_COUPON_QING_TIAN(72, "美团代金券-晴天"),

    CAR_SER_CAR_AFTER(73,"汽车服务-车后"),
    CAR_SER_CAR_MOM(75,"汽车服务-车妈妈"),
    CAR_SER_CAR_EASY(76,"汽车服务-车易行"),
    I_QI_YI_FENG_ZHU_SHOU(77, "爱奇艺会员-蜂助手"),
    E_LE_ME_VIP_FU_LU(78, "饿了么超级会员-福禄"),
    E_LE_ME_VIP_DING_XIN(79, "饿了么超级会员-鼎信"),
    YOU_KU_QING_TIAN(80, "优酷会员-晴天"),

    DOUYIN_PAY_COUPON(74,"抖音支付券"),
    WX_TRANSFER_HAN_GONG_YUN(81, "汉工云-微信零钱"),

    KA_CHI_ALI_PAY_COUPON(82, "卡池-支付宝立减金"),
    ;

    /**
     * 类型
     */
    private final Integer type;

    /**
     * 描述
     */
    private final String desc;


    private static final Map<Integer, ChannelTypeEnum> ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(ChannelTypeEnum::getType, Function.identity(), (v1, v2) -> v2)));

    public static ChannelTypeEnum getByType(Integer type) {
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }
}
