package cn.com.duiba.supplier.channel.service.api.enums.channel;

import cn.com.duiba.boot.exception.BizException;
import lombok.Getter;
import lombok.RequiredArgsConstructor;

import java.util.Objects;

/**
 * FuLuCodeEnum
 *
 * @author fmk
 * @since 2024/3/1
 */
@RequiredArgsConstructor
@Getter
public enum FuLuCodeEnum {

    INTERFACE_CALL_SUCCESS(0, "接口调用成功"),
    MISSING_API_NAME(1000, "必须传入API接口名称"),
    INVALID_API_NAME(1001, "无效的API接口名称"),
    MISSING_TIMESTAMP(1002, "必须传入时间戳"),
    INVALID_TIMESTAMP_FORMAT(1003, "时间戳格式错误"),
    TIMESTAMP_EXPIRED(1004, "时间戳已超过有效期"),
    MISSING_APP_KEY(1005, "必须传入app_key"),
    INVALID_APP_KEY(1006, "无效的app_key"),
    MISSING_VERSION(1007, "必须传入版本号"),
    INVALID_VERSION(1008, "版本号错误"),
    MISSING_FORMAT(1009, "必须传入format格式"),
    INVALID_FORMAT(1010, "format格式错误"),
    MISSING_CHARSET(1011, "必须传入编码格式"),
    INVALID_CHARSET(1012, "编码格式错误"),
    MISSING_SIGN_TYPE(1013, "必须传入签名加密类型"),
    INVALID_SIGN_TYPE(1014, "签名加密类型错误"),
    MISSING_SIGN(1015, "必须传入签名"),
    INVALID_SIGN(1016, "签名错误"),
    MISSING_BIZ_CONTENT(1017, "必须传入请求参数集合"),
    MISSING_REQUIRED_PARAM(1018, "缺少必要参数"),
    IP_NOT_IN_WHITELIST(1019, "访问IP不在IP白名单内"),
    INVALID_MERCHANT_OR_APP(2002, "无效的商户或应用"),
    MERCHANT_APP_CONFIGURATION_EXCEPTION(2003, "商户或应用配置异常"),
    INSUFFICIENT_MERCHANT_BALANCE(2004, "商户余额不足"),
    MISSING_PRODUCT_ID(3000, "必须传入商品编号"),
    INVALID_PRODUCT(3001, "商品不存在或无法购买"),
    PRODUCT_OFFLINE(3002, "商品已下架"),
    PRODUCT_UNDER_MAINTENANCE(3003, "商品维护中"),
    PRODUCT_UNDER_MAINTENANCE_PERIOD(3004, "商品在维护期内"),
    INSUFFICIENT_PRODUCT_STOCK(3005, "商品库存不足"),
    INVALID_PRODUCT_TYPE(3008, "商品类型错误"),
    MISSING_CUSTOMER_ORDER_NO(4000, "必须传入外部订单号"),
    INVALID_BUY_NUM(4001, "购买数量必须大于0"),
    MISSING_CHARGE_ACCOUNT(4002, "必须传入充值账号"),
    CHARGE_ACCOUNT_BLACKLISTED(4004, "充值账号在黑名单中"),
    ADD_ORDER_FAILURE(4008, "添加订单失败"),
    ORDER_TIMEOUT(4009, "执行下单超时，请查单确认下单结果"),
    DUPLICATE_EXTERNAL_ORDER_NO(4010, "外部订单号已存在"),
    QUERY_EXCEPTION_RETRY(4012, "查询异常，请重试"),
    SYSTEM_SUSPICIOUS(5000, "系统异常，订单可疑"),
    SYSTEM_EXCEPTION(5001, "系统异常");

    private final int code;
    private final String message;

    public static FuLuCodeEnum convert(Integer code) throws BizException {
        for (FuLuCodeEnum codeEnum : values()) {
            if (Objects.equals(codeEnum.getCode(), code)) {
                return codeEnum;
            }
        }
        throw new BizException("状态码错误,code=" + code);
    }

}
