package cn.com.duiba.supplier.channel.service.api.dto.request.conf;

import lombok.Data;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

/**
 * 渠道告警表
 * @author mybatis generator 
 * @date 2023-12-12
 */
@Data
@ToString(callSuper = true)
public class WxMchSearchParam implements Serializable {

    private static final long serialVersionUID = 17023738095449251L;

    /**
     * 商户号ID
     */
    private String mchId;

    /**
     * 商户号名称
     */
    private String mchName;

    /**
     * 当前页
     */
    private Integer pageIndex = 1;

    /**
     * 页数量
     */
    private Integer pageSize = 20;

    public Integer getOffset() {
        if (Objects.nonNull(pageIndex) && Objects.nonNull(pageSize)) {
            return (pageIndex - 1) * pageSize;
        }
        return null;
    }



}