package cn.com.duiba.supplier.channel.service.api.dto.response.wx.favor;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 满减券信息
 * @author lizhi
 * @date 2023/8/19 18:25
 */
@Data
public class WxFavorStockUseRuleDto implements Serializable {
    
    private static final long serialVersionUID = 3999419787529555903L;

    /**
     * 发放总上限					 
     * 说明：最大发券数
     * 示例值：100
     * 必填，uint64
     */
    private Long maxCoupons;

    /**
     * 总预算								 
     * 说明：总消耗金额，单位：分。
     * 示例值：5000
     * 必填，uint64
     */
    private Long maxAmount;

    /**
     * 单天发放上限金额							 
     * 说明：单天最高消耗金额，单位：分。
     * 示例值：400
     * 必填，uint64
     */
    private Long maxAmountByDay;

    /**
     * 单个用户可领个数							 
     * 说明：单个用户可领个数，每个用户最多100张券
     * 示例值：3
     * 必填，uint32
     */
    private Integer maxCouponsPerUser;

    /**
     * 券类型								 
     * 说明：券类型
     * 枚举值：
     * NORMAL：满减券
     * CUT_TO：减至券
     * 示例值：NORMAL
     * 非必填，string(16)
     */
    private String couponType;

    /**
     * 支付方式									 
     * 说明：默认不限制
     * 枚举值：
     * MICROAPP：小程序支付
     * APPPAY：APP支付
     * PPAY：免密支付
     * CARD：付款码支付
     * FACE：人脸支付
     * OTHER：（公众号、扫码等）
     * 示例值：["OTHER","APPPAY"]
     * 必填，string(16)
     */
    private List<String> tradeType;

    /**
     * 是否可叠加其他优惠								 
     * 说明：枚举值：
     * true：是
     * false：否
     * 示例值：true
     * 非必填，bool
     */
    private Boolean combineUse;

    /**
     * 固定面额批次特定信息
     * 说明：固定面额发券批次特定信息。
     * 非必填
     */
    private WxFavorFixedNormalCouponDto fixedNormalCoupon;
}
