package cn.com.duiba.supplier.channel.service.api.enums.channel;


import lombok.AllArgsConstructor;
import lombok.Getter;

@Getter
@AllArgsConstructor
public enum MeiTuanCouponNotifyStatusEnum {
    WRITE_OFF("2", "核销"),
    REFUND("3", "退券"),
    EXPIRED("5", "过期"),
    ;

    /**
     * 状态码
     */
    private final String code;
    /**
     * 描述
     */
    private final String desc;

    //根据状态码获取枚举
    public static MeiTuanCouponNotifyStatusEnum getByCode(Integer code) {
        for (MeiTuanCouponNotifyStatusEnum statusEnum : values()) {
            if (statusEnum.code.equals(code)) {
                return statusEnum;
            }
        }
        return null;
    }
}
