package cn.com.duiba.supplier.channel.service.api.remoteservice.ruixingcoffee;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.supplier.channel.service.api.dto.request.BaseReq;
import cn.com.duiba.supplier.channel.service.api.dto.request.ruixingcoffee.DingXinRuiXingCoffeeZcReq;
import cn.com.duiba.supplier.channel.service.api.dto.response.BaseResp;
import cn.com.duiba.supplier.channel.service.api.dto.response.BaseResultResp;
import cn.com.duiba.supplier.channel.service.api.dto.response.ruixingcoffee.DingXinRuiXingCoffeeZcResp;
import cn.com.duiba.supplier.channel.service.api.enums.order.BizTypeEnum;

/**
 * 鼎信-瑞希咖啡代金券-RPC
 *
 * @author fmk
 * @since 2024/1/2
 */
@AdvancedFeignClient
public interface RemoteDingXinRuiXingCoffeeZcService {

    /**
     * 发放
     * 注意：若结果以mq回调，业务方需要根据业务类型+业务单号幂等<br/>
     * 长时间收不到回调调用查询接口查询<br/>
     *
     * @param request 发放请求参数
     * @return 本次请求是否成功
     */
    BaseResp distribute(BaseReq<DingXinRuiXingCoffeeZcReq> request);

    /**
     * 查询发放结果
     *
     * @param bizType 业务类型
     *                {@link BizTypeEnum}
     * @param bizNo   业务方唯一单号
     * @return 发放结果
     */
    BaseResultResp<DingXinRuiXingCoffeeZcResp> distributeResult(Integer bizType, String bizNo);

}
