package cn.com.duiba.supplier.channel.service.api.dto.request.bawangchaji;

import java.io.Serializable;
import javax.validation.constraints.NotBlank;
import lombok.Data;

/**
 * 继皋-霸王茶姬直冲请求参数
 */
@Data
public class JiGaoBaWangChaJiReq implements Serializable {

    private static final long serialVersionUID = -1809236486422044277L;

    /**
     * 商户编号
     */
    @NotBlank(message = "商户编号不能为空")
    private String channelId;

    /**
     * 订单号
     */
    @NotBlank(message = "订单号不能为空")
    private String orderNo;

    /**
     * 充值账号
     */
    @NotBlank(message = "充值账号不能为空")
    private String accountNo;

    /**
     * 商品编码
     */
    @NotBlank(message = "商品编码不能为空")
    private String productId;

    /**
     * 是否有发票：0无票、1专票、2零票，默认为1
     */
    @NotBlank(message = "是否有发票")
    private String voiceFlag;
}
