package cn.com.duiba.supplier.channel.service.api.dto.response.youku;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import java.io.Serializable;

/**
 * 优酷直充发放响应结果
 *
 * @author wangguanhua
 */
@Data
public class YoukuResp implements Serializable {

    private static final long serialVersionUID = -4888030303935705246L;

    /**
     * 商家订单 id
     */
    @JSONField(name = "out_order_no")
    private String outOrderNo;

    /**
     * 商家 id
     */
    @JSONField(name = "business_id")
    private String businessId;

    /**
     * 商家活动 id
     */
    @JSONField(name = "activity_id")
    private String activityId;

    /**
     * 优酷订单 id
     */
    @JSONField(name = "youku_order")
    private String youkuOrder;

    /**
     * 优酷订单状态（1-创建中，2-失败，3-完成）
     */
    @JSONField(name = "order_state")
    private String orderState;

    /**
     * 商品数量
     */
    @JSONField(name = "num")
    private String num;

    /**
     * 创建时间
     */
    @JSONField(name = "ctime")
    private String ctime;

    /**
     * 完成时间
     */
    @JSONField(name = "succ_time")
    private String succTime;
}
