package cn.com.duiba.supplier.channel.service.api.enums.channel;

import cn.com.duiba.boot.exception.BizException;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 玉镜状态码
 */
@Getter
@AllArgsConstructor
public enum YuJingCodeEnum {


    SUCCESS("0000", "请求成功"),//只代表请求成功

    //=======================下单接口返回码=====================

    PARAM_ERROR("1001", "请求参数缺失"),

    MCH_ERROR("1002", "商户状态不正常"),

    MCH_PAY_ERROR("1003", "商户支付密码错误"),

    MCH_NOT_EXIST("1004", "商户不存在"),

    IP_CONFIG_ERROR("1005", "未配置IP白名单"),

    ORDER_NOT_EXIST("1006", "订单号重复"),

    MCH_BUSINESS_CONFIG_ERROR("1007", "商户业务配置异常"),

    NOT_SUPPORT_NUMBER("1008", "暂不支持本号段"),

    NOT_SUPPORT_PRODUCT("1009", "暂不支持本商品"),

    SIGN_ERROR("1010", "签名失败"),

    BALANCE_NOT_ENOUGH("1016", "余额不足"),

    ORDER_INSERT_ERROR("1017", "订单入库失败"),

    SYSTEM_MAINTENANCE("1021", "系统维护中"),

    TIMESTAMP_ERROR("1025", "时间戳差异超3分钟"),


    //查询接口返回码
    //订单不存在
    ORDER_NOT_EXIST_TWO("2001", "订单不存在"),



    SYSTEM_ERROR("9999", "系统异常"),

    ;


    public static List<String> failCodeList() {
        return Stream.of(PARAM_ERROR.getCode(),MCH_ERROR.getCode(),MCH_PAY_ERROR.getCode(),MCH_NOT_EXIST.getCode(),
                IP_CONFIG_ERROR.getCode(),ORDER_NOT_EXIST.getCode(),MCH_BUSINESS_CONFIG_ERROR.getCode(),NOT_SUPPORT_NUMBER.getCode(),
                NOT_SUPPORT_PRODUCT.getCode(),SIGN_ERROR.getCode(),BALANCE_NOT_ENOUGH.getCode(),ORDER_INSERT_ERROR.getCode(),SYSTEM_MAINTENANCE.getCode(),
                TIMESTAMP_ERROR.getCode()
        ).collect(Collectors.toList());
    }
    public static YuJingCodeEnum getByCode(String code) throws BizException {
        for (YuJingCodeEnum value : values()) {
            if (value.getCode().equals(code)) {
                return value;
            }
        }
        throw new BizException("未找到对应的枚举值");
    }

    private final String code;

    private final String description;
}
