package cn.com.duiba.supplier.channel.service.api.dto.request.dingtalk;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @author xuzhigang
 * @date 2024/10/22 11:35
 **/
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class GetApprovalProcessForecastRequest extends BaseRequest {
    private static final long serialVersionUID = -1519750048175438320L;

    /**
     * 审批模板code
     */
    @NotBlank
    private String processCode;

    /**
     * 部门id
     */
    @NotNull
    private Long deptId;

    /**
     * 即将发起审批单的员工userId值。
     */
    @NotBlank
    private String userId;

    /**
     * 表单数据内容，控件列表，最大列表长度：150。
     */
    @NotEmpty
    private List<ApprovalFormComponentValue> formComponentValues;
}
