package cn.com.duiba.supplier.channel.service.api.dto.response.dingtalk;

import cn.com.duiba.supplier.channel.service.api.dto.dingtalk.DingTalkApprovalRecordDto;
import cn.com.duiba.supplier.channel.service.api.dto.dingtalk.DingTalkApprovalTaskDto;
import cn.com.duiba.supplier.channel.service.api.dto.request.dingtalk.ApprovalFormComponentValue;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author xuzhigang
 * @date 2024/10/19 11:43
 **/
@Data
public class GetApprovalDetailResponse implements Serializable {
    private static final long serialVersionUID = 8530952211417648895L;

    /**
     * 审批实例标题
     */
    private String title;

    /**
     * 审批结束时间
     */
    private String finishTime;

    /**
     * 发起人的用户id
     */
    private String originatorUserId;

    /**
     * 发起人的部门id
     */
    public String originatorDeptId;

    /**
     * 审批创建时间
     */
    private String createTime;

    /**
     * 审批状态
     * RUNNING：审批中
     * TERMINATED：已撤销
     * COMPLETED：审批完成
     */
    private String approvalStatus;

    /**
     * 审批结果
     * agree：同意
     * refuse：拒绝
     * 说明
     * status为COMPLETED且result为agree时，表示审批单完结并审批通过。
     */
    private String approvalResult;

    /**
     * 抄送人用户id逗号分割集合
     */
    private List<String> ccUserIds;

    /**
     * 审批人用户id
     */
    private List<String> approverUserIds;

    /**
     * 操作记录列表
     */
    private List<DingTalkApprovalRecordDto> operationRecords;

    /**
     * 任务列表
     */
    private List<DingTalkApprovalTaskDto> tasks;

    /**
     * 审批流程节点列表
     */
    private List<ApprovalProcessForecastWorkFlowActivityRule> workFlowActivityRules;

    /**
     * 表单信息
     */
    private List<ApprovalFormComponentValue> formComponentValues;

    /*******************填充参数******************/

    /**
     * 审批实例变更 回调通知topic
     */
    private String instanceChangeTopic;

    /**
     * 审批实例变更 回调通知tag
     */
    private String instanceChangeTag;


    /**
     * 审批流的唯一码
     */
    private String processCode;

}
