package cn.com.duiba.supplier.channel.service.api.enums.alipay;


import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 支付宝立减金调用接口枚举
 * 立减: DISCOUNT
 * 通用渠道红包: VOUCHER
 * 首绑有礼: FIRST_BIND_CARD_GIFT
 */
@Getter
@AllArgsConstructor
public enum AlipayActivityTypeApiEnum {
    DISCOUNT("立减"),
    VOUCHER("通用渠道红包"),
    FIRST_BIND_CARD_GIFT("首绑有礼"),
    ;

    /**
     * 描述
     */
    private final String des;

}