package cn.com.duiba.supplier.channel.service.api.dto.conf;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 支付宝商户配置表
 * @author kjj mybatis generator 
 * @date 2023-04-17
 */
@Data
public class WxPayMchConfDto implements Serializable {

    private static final long serialVersionUID = 515364478211699238L;

    /**
     * id 主键
     */
    private Long id;

    /**
     * 微信商户id
     */
    private String mchId;

    /**
     * 微信商户类型
     *  1：内部商户
     *  2：外部商户
     *  等等
     */
    private Integer mchType;

    /**
     * 商户名称
     */
    private String mchName;

    /**
     * api秘钥
     */
    private String apiKey;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 微信api证书
     */
    private String apiCert;

    /**
     * APIv3密钥
     */
    private String apiV3Key;

    /**
     * 账户余额
     */
    private Long accountBalance;
}