package cn.com.duiba.supplier.channel.service.api.dto.conf;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 支付宝商户配置表
 * @author kjj mybatis generator 
 * @date 2023-04-17
 */
@Data
public class AlipayMchConfDto implements Serializable {

    private static final long serialVersionUID = 515364478211699238L;
    
    /**
     * id 主键
     */
    private Long id;

    /**
     * 支付宝应用id
     */
    private String appId;

    /**
     * 应用名称
     */
    private String appName;

    /**
     * 应用公钥
     */
    private String publicKey;

    /**
     * 支付宝公钥
     */
    private String alipayPublicKey;

    /**
     * 私钥
     */
    private String privateKey;

    /**
     * 商户号
     */
    private String mchCode;

    /**
     * 账户余额
     */
    private Long accountBalance;

    /**
     * 警告开关，0-关闭，1-开启
     */
    private Integer warnStatus;

    /**
     * 警告余额阈值，默认0
     */
    private Long warnBalanceThreshold;
}