package cn.com.duiba.supplier.channel.service.api.remoteservice.conf;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.supplier.channel.service.api.dto.conf.AlipayMchConfDto;
import cn.com.duiba.supplier.channel.service.api.dto.request.alipay.AlipayMchSearchParam;
import cn.com.duiba.supplier.channel.service.api.dto.response.alipay.AlipayCouponMchNameDto;

import java.util.List;
import java.util.Map;

/**
 * 支付宝支付商户配置
 * @author yangyukang
 * @date 2023/9/23 17:50
 */
@AdvancedFeignClient
public interface RemoteAlipayMchConfService {

    /**
     * 查询所有的商户名称
     * @return key：mchId，value：商户名称
     */
    List<AlipayCouponMchNameDto> selectAllMchNameMap();

    /**
     * 根据appId查询 底层走本地缓存
     * @param appId 支付宝应用id
     * @return 支付宝商户配置
     */
    AlipayMchConfDto selectByAppId(String appId);

    /**
     * 查询应用id和商户号的映射关系
     *
     * @param appIds 应用id
     * @return key: 应用id value: 商户号
     */
    Map<String, String> selectMchCodeMap(List<String> appIds);

    /**
     * 分页查询
     * @param param 查询参数
     * @return 支付宝商户配置
     */
    List<AlipayMchConfDto> selectPage(AlipayMchSearchParam param);

    /**
     * 查询总数
     * @param param 查询参数
     * @return 总数
     */
    Long selectCount(AlipayMchSearchParam param);

    /**
     * 更新警告信息
     */
    int updateWarnInfo(AlipayMchConfDto dto);

    /**
     * 更新余额
     */
    int updateBalance(AlipayMchConfDto dto);
}
