package cn.com.duiba.supplier.channel.service.api.remoteservice.conf;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.supplier.channel.service.api.dto.conf.WxPayMchConfDto;
import cn.com.duiba.supplier.channel.service.api.dto.request.conf.WxMchSearchParam;
import cn.com.duiba.supplier.channel.service.api.enums.conf.MchTypeEnum;

import java.util.List;
import java.util.Map;

/**
 * 微信支付商户配置
 * @author lizhi
 * @date 2023/8/19 17:50
 */
@AdvancedFeignClient
public interface RemoteWxpayMchConfService {

    /**
     * 查询所有的商户名称
     * @return key：mchId，value：商户名称
     */
    Map<String, String> selectAllMchNameMap();

    /**
     * 查询所有的商户名称，根据商户类型
     * @param mchType 商户类型
     *                {@link MchTypeEnum}
     * @return key：mchId，value：商户名称
     */
    Map<String, String> selectAllMchNameMapByMchType(Integer mchType);

    /**
     * 分页查询
     * @param param
     * @return
     */
    List<WxPayMchConfDto> selectPage(WxMchSearchParam param);

    /**
     * 查询总数
     * @param param
     * @return
     */
    long selectCount(WxMchSearchParam param);

    /**
     * 根据主键查询
     * @param id
     * @return
     */
    WxPayMchConfDto selectById(Long id);


    /**
     * 根据商户号查询
     * @param mchId
     * @return
     */
    WxPayMchConfDto selectByMchId(String mchId);


    /**
     * 更新账户余额
     * @param dto
     * @return
     */
    int update(WxPayMchConfDto dto);

    /**
     * 查询总余额
     * @param param
     * @return
     */
    long selectSumBalance(WxMchSearchParam param);

    /**
     * 更新警告信息
     */
    int updateWarnInfo(WxPayMchConfDto dto);
}
