package cn.com.duiba.supplier.channel.service.api.dto.dingtalk.callback;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 审批实例变更信息
 *
 * @author xuzhigang
 * @date 2024/10/21 14:21
 **/
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class BpmsInstanceChangeDto extends BpmsEventEventCallbackBaseDto {
    private static final long serialVersionUID = -2147588174256199311L;

    /**
     * 实例创建时间
     */
    private Long createTime;

    /**
     * 审批结束时间
     */
    private Long finishTime;

    /**
     * 实例状态变更类型：
     * start：审批实例开始
     * finish：审批正常结束（同意或拒绝）
     * terminate：审批终止（发起人撤销审批单）
     * delete：审批实例删除
     * {@link cn.com.duiba.supplier.channel.service.api.enums.dingtalk.BpmsInstanceTypeEnum}
     */
    private String type;

    /**
     * 审批实例url，可在钉钉内跳转到审批页面。
     */
    private String url;

    /**
     * 业务分类标识。
     */
    private String bizCategoryId;

    /**
     * 审批结果(审批终止时无此参数)：
     * agree： 同意
     * refuse：拒绝
     * {@link cn.com.duiba.supplier.channel.service.api.enums.dingtalk.BpmsInstanceResultEnum}
     */
    private String result;

    /**
     * 发起审批实例的员工userId。
     */
    private String staffId;

    /**
     * 业务身份
     */
    private String businessType;
}
