package cn.com.duiba.supplier.channel.service.api.enums.channel;

import lombok.Getter;

/**
 * 车点点
 * 200：成功
 * 201：重复调用（也返回券信息）
 * 202：处理中
 * 300：申请失败，原因见Msg字段
 * -1：系统异常
 * @author cxw
 * @date 2024/07/19
 */
@Getter
public enum CheDianDianStatusEnum {

    // 以下状态为进行中
    SUCCESS(200, "成功"),
    SUCCESS_CAN_RETRY(201, "成功且重复调用"),
    PROCESSING(202, "处理中"),
    FAIL(300, "申请失败"),
    ERROR(-1, "系统异常"),
;


    private final Integer code;
    private final String message;

    CheDianDianStatusEnum(Integer code, String message) {
        this.code = code;
        this.message = message;
    }


}
