package cn.com.duiba.supplier.channel.service.api.dto.request.wx.favor;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * 导入定向用户协议号API请求参数
 * @author lfh
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class WxFavorImportUserAgreementNumberRequest implements Serializable {


    private static final long serialVersionUID = 7111378271707251360L;
    /**
     * 商户ID
     */
    private String mchId;
    /**
     * 号码包id
     * 说明：号码包唯一标识符。可在微信支付商户平台创建号码包后获得。
     */
    private String packageId;

    /**
     * 任务上传的文件
     * 文件大小不能超过2MB，建议单个文件的行数不超过5500行。同一个号码包的多个上传任务的文件名不可重复。
     */
    private List<String> content;

    /**
     * 任务上传的文件类型
     */
    private String contentType;

    /**
     * 任务上传的文件名
     */
    private String filename;

    /**
     * 银行类型
     * 用于标识协议号所属的银行以及卡类型(信用卡或借记卡)。采用字符串类型的银行标识
     */
    private String bankType;

}
