package cn.com.duiba.supplier.channel.service.api.dto.response.carser;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

@Data
public class CarMomQueryMchResp implements Serializable {

    private static final long serialVersionUID = -1L;

    /**
     * 店铺名称
     */
    private String storeName;

    /**
     * 店铺编码
     */
    private String plateCode;

    /**
     * 省份名称
     */
    private String province;

    /**
     * 市名称
     */
    private String city;

    /**
     * 区县名称
     */
    private String district;

    /**
     * 省份编码
     */
    private String provinceCode;

    /**
     * 城市编码
     */
    private String cityCode;

    /**
     * 区县编码
     */
    private String districtCode;

    /**
     * 维度
     */
    private String latitude;

    /**
     * 经度
     */
    private String longitude;

    /**
     * 店铺图片
     */
    private String headImg;

    /**
     * 店铺详细地址
     */
    private String address;

    /**
     * 店铺营业时间,
     * 格式：00:00-23:59
     */
    private String businessHours;

    /**
     * 店铺能做的项目的车妈妈平台的code码合集
     */
    private String goodeCodeFull;

    /**
     * 店铺状态，1合作中；2下架；
     */
    private String storeState;

    /**
     * 店铺是否营业时，1营业中，0不营业（店铺状态优先级更高，下架店铺还是可能是营业状态，注意判断）
     */
    private String isBusinessHours;

    /**
     * 服务项目价格集合
     */
    private List<CarMomQueryMchGoodsPriceResp> goodsPrice;
}
