package cn.com.duiba.supplier.channel.service.api.dto.response.guming;

import lombok.Data;

import java.io.Serializable;

/**
 * GuMingNotifyResp
 *
 * @author fmk
 * @since 2024/7/12
 */
@Data
public class GuMingNotifyResp implements Serializable {

    private static final long serialVersionUID = 6891420218631063298L;

    /**
     * 券码
     */
    private String couponCode;

    /**
     * 领券时的ID
     */
    private String orderId;

    /**
     * 状态
     * CONFIRM:核销
     * ROLLBACK:撤销核销
     * @see cn.com.duiba.supplier.channel.service.api.enums.channel.GuMingNotifyStatusEnum
     */
    private String status;

    /**
     * 店铺编码
     */
    private String shopNo;

    /**
     * 店铺名称
     */
    private String shopName;

    /**
     * 下单订单号
     */
    private String bizOrderNo;

    /**
     * 发放时间
     */
    private String distributeTime;

    /**
     * 核销时间
     */
    private String cancelTime;

    /**
     * 退款时间
     */
    private String refundTime;

}
