package cn.com.duiba.supplier.channel.service.api.enums.channel;

import cn.com.duiba.boot.exception.BizException;
import lombok.Getter;
import lombok.RequiredArgsConstructor;

/**
 * HongEnCodeEnum
 *
 * @author fmk
 * @since 2024/4/1
 */
@Getter
@RequiredArgsConstructor
public enum HongEnCodeEnum {

    SUCCESS("0", "请求成功"),
    PARAMETER_ERROR("102", "参数错误（如合作方编号为空等）"),
    SIGNATURE_ERROR("103", "签名错误"),
    SYSTEM_ERROR("301", "系统错误"),
    ITEM_NOT_ON_SHELF("6001", "商品未上架，洪恩业务侧判定合作商品上架状态"),
    USER_RIGHTS_CONFLICT("6002", "用户权益冲突（洪恩业务侧来判定权益是否冲突）"),
    ORDER_NOT_FOUND("6003", "未查询到订单信息"),
    UNSUPPORTED_SYSTEM_OPERATION("6004", "暂不支持的系统操作");

    private final String code;
    private final String description;

    public static HongEnCodeEnum getByCode(String code) throws BizException {
        for (HongEnCodeEnum value : values()) {
            if (value.getCode().equals(code)) {
                return value;
            }
        }
        throw new BizException("未找到对应的枚举值");
    }
}
