package cn.com.duiba.supplier.channel.service.api.enums.channel;

import java.util.Arrays;
import java.util.List;

/**
 * @author cxw
 * @date 2024/07/19
 */
public enum QingTianCodeEnum {

    SUCCESS("0000", "成功"),
    ORDER_SUCCESS("2000", "下单成功"),
    REPEAT("1005", "下单重复"),
    E1000("1000", "ip未绑定或绑定失败"),
    E1001("1001", "参数异常"),
    E1002("1002", "无效商户信息"),
    E1003("1003", "签名校验失败"),
    E1004("1004", "请求时间过期"),
    E1006("1006", "商品暂停使用"),
    E1007("1007", "商品价格无效"),
    E1008("1008", "金额不足"),
    E1009("1009", "商品映射无效"),
    E1010("1010", "映射价格无效"),
    E1011("1011", "账号格式不匹配"),
    E1012("1012", "无订单信息"),
    E1101("1101", "校验京东短信验证码失败"),
    E1102("1102", "验证码过期"),
    E1100("1100", "验证码发送失败"),
    E5001("5001", "系统异常(可能是网络异常等原因)"),


    ;

    private String code;
    private String message;

    QingTianCodeEnum(String code, String message) {
        this.code = code;
        this.message = message;
    }


    final static List<String> SUCCESS_CODES = Arrays.asList(QingTianCodeEnum.SUCCESS.getCode(), QingTianCodeEnum.ORDER_SUCCESS.getCode(), QingTianCodeEnum.REPEAT.getCode());

    public final static List<String> ERROR_CODES = Arrays.asList(
            QingTianCodeEnum.E1000.getCode()
            ,QingTianCodeEnum.E1001.getCode()
            ,QingTianCodeEnum.E1002.getCode()
            ,QingTianCodeEnum.E1003.getCode()
            ,QingTianCodeEnum.E1004.getCode()
            ,QingTianCodeEnum.E1006.getCode()
            ,QingTianCodeEnum.E1007.getCode()
            ,QingTianCodeEnum.E1008.getCode()
            ,QingTianCodeEnum.E1009.getCode()
            ,QingTianCodeEnum.E1010.getCode()
            ,QingTianCodeEnum.E1011.getCode()
            ,QingTianCodeEnum.E1012.getCode()
            ,QingTianCodeEnum.E1101.getCode()
    );

    /**
     * 是否包含错误内容
     * @return
     */
    public static boolean errorContain(String code){
        return ERROR_CODES.contains(code);
    }

    /**
     * 是否包含错误内容
     * @return
     */
    public static boolean successContain(String code){
        return SUCCESS_CODES.contains(code);
    }


    public String getCode() {
        return code;
    }

    public String getMessage() {
        return message;
    }
}
