package cn.com.duiba.supplier.channel.service.api.enums.channel;

import cn.com.duiba.boot.exception.BizException;
import lombok.AllArgsConstructor;
import lombok.Getter;

@Getter
@AllArgsConstructor
public enum YiAnCodeEnum {

    SUCCESS("00", "成功"),
    SYSTEM_MAINTAINING("-10", "系统维护中"),
    PARAM_ERROR("-12", "参数错误(参数缺失/参数格式不正确/黑名单)"),
    SPEEDING("-13", "请求超速"),
    AUTHENTICATION_FAILED("-14", "鉴权失败(签名校验未通过/IP校验未通过/帐号已冻结)"),
    CHARGE_FAILED("-15", "订购失败（商品不存在/商品未配置/商品维护中/不支持该地区/面值校验未通过/结算价校验未通过）"),
    REPEAT_ORDER("-16", "重复下单(存疑处理)"),
    REMAINDER_NO_MONEY("-18", "余额不足"),
    CARD_FAILED("-21", "提卡失败"),
    CARD_ERROR("-22", "提卡异常(存疑处理)"),
    CARD_TIMEOUT("-23", "提卡超时(存疑处理)"),
    SYSTEM_ERROR("-99", "系统异常(存疑处理)"),
    ;

    /**
     * 结果码
     */
    @Getter
    private final String code;

    /**
     * 描述
     */
    private final String remark;

    public static YiAnCodeEnum getByCode(String code) throws BizException {
        for (YiAnCodeEnum value : values()) {
            if (value.getCode().equals(code)) {
                return value;
            }
        }
        throw new BizException("未找到对应的枚举值");
    }
}
