package cn.com.duiba.supplier.channel.service.api.enums.express;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 物流类型
 *
 * @author wangguanhua
 */
@Getter
@AllArgsConstructor
public enum ExpressTypeEnum {

    KUAIDI100(1, "快递100"),
    ;

    private static final Map<Integer, ExpressTypeEnum> ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(ExpressTypeEnum::getType, Function.identity(), (v1, v2) -> v2)));

    /**
     * 类型
     */
    private final Integer type;

    /**
     * 描述
     */
    private final String desc;

    public static ExpressTypeEnum getByType(Integer type) {
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }

}
