package cn.com.duiba.supplier.channel.service.api.remoteservice.alipay;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.supplier.channel.service.api.dto.request.BaseReq;
import cn.com.duiba.supplier.channel.service.api.dto.request.alipay.AlipayCountCoinsReq;
import cn.com.duiba.supplier.channel.service.api.dto.request.alipay.AlipayCouponCardReq;
import cn.com.duiba.supplier.channel.service.api.dto.response.BaseResultResp;
import cn.com.duiba.supplier.channel.service.api.dto.response.BaseResp;
import cn.com.duiba.supplier.channel.service.api.dto.response.alipay.AlipayActivityInfoResp;
import cn.com.duiba.supplier.channel.service.api.dto.response.alipay.AlipayCouponCardNotifyResp;
import cn.com.duiba.supplier.channel.service.api.dto.response.alipay.AlipayCouponCardResp;
import cn.com.duiba.supplier.channel.service.api.enums.order.BizTypeEnum;

import java.util.Map;

/**
 * 支付宝立减金
 * @author lizhi
 * @date 2023/4/20 1:44 PM
 */
@AdvancedFeignClient
public interface RemoteAlipayCouponService {

    /**
     * 支付宝获取用户ID
     * @param appId 支付宝应用ID
     * @param authCode 授权码
     * @return 支付宝user_id
     */
    String queryAlipayUserIdByAuthCode(String appId, String authCode);

    /**
     * 发放
     * 注意：若结果以mq回调，业务方需要根据业务类型+业务单号幂等<br/>
     * 长时间收不到回调调用查询接口查询<br/>
     *
     * @param request 发放请求参数
     * @return 本次请求是否成功
     */
    BaseResp distribute(BaseReq<AlipayCouponCardReq> request);

    /**
     * 查询支付宝立减金发放结果
     *
     * @param bizType 业务类型
     *        {@link BizTypeEnum}
     * @param bizNo 业务方唯一单号
     * @return 发放结果
     */
    BaseResultResp<AlipayCouponCardResp> alipayCouponDistributeResult(Integer bizType, String bizNo);

    /**
     * 查询支付宝立减金详情
     * @param appId 支付宝应用ID
     * @param batchNo 批次id
     * @return 支付宝立减金详情
     */
    AlipayActivityInfoResp getAlipayActivityInfo(String appId, String batchNo);

    /**
     * 查询支付宝立减金详情
     * @param appId 支付宝应用ID
     * @param batchNo 批次id
     * @param activityType 活动类型 {@link cn.com.duiba.supplier.channel.service.api.enums.alipay.AlipayActivityTypeApiEnum}
     * @return 支付宝立减金详情
     */
    AlipayActivityInfoResp getAlipayActivityInfoByActivityType(String appId, String batchNo, String activityType);

    /**
     * 发放数币红包
     * 注意：若结果以mq回调，业务方需要根据业务类型+业务单号幂等<br/>
     * 长时间收不到回调调用查询接口查询<br/>
     * @param request 发放请求参数
     * @return 本次请求是否成功
     */
    BaseResp distributeCountCoins(BaseReq<AlipayCountCoinsReq> request);

    /**
     * 支付宝回调校验签名
     * 
     * @param params 回调参数
     * @return 通知内容
     */
    AlipayCouponCardNotifyResp notifyValidate(Map<String, String> params);

}
