package cn.com.duiba.supplier.channel.service.api.dto.request.alipay;

import lombok.Data;

import java.io.Serializable;

/**
 * 数字分行用户账号查询接口
 * @author lizhi
 * @date 2024/1/15 17:54
 */
@Data
public class AlipayDtBankCustAccountQueryReq implements Serializable {
    
    private static final long serialVersionUID = -8815000524515642530L;

    /**
     * 支付宝应用ID
     */
    private String appId;

    /**
     * 用户登录账号ID，logon_id，phone_id不能同时为空，二选一
     * 示例值:xxx@163.com
     * 长度范围：[1,50]
     */
    private String logonId;

    /**
     * 用户手机号，logon_id，phone_id不能同时为空，二选一
     * 示例值:139xxxxxxxx
     * 长度范围：[1,50]
     */
    private String phoneId;
}
