package cn.com.duiba.supplier.channel.service.api.dto.request.douyin;

import lombok.Data;

import java.io.Serializable;

/**
 * 抖音券状态查询参数
 */
@Data
public class DouYinCouponStatusReq implements Serializable {
    private static final long serialVersionUID = 1191073313547614927L;
    /**
     * 用户openid/手机号
     * 领券的用户openid，或用户加密手机号(SHA256，纯小写)。
     * 示例值:2323dfsdf342342
     */
    private String openid;

    /**
     * 券唯一标识
     */
    private String couponCode;

    /**
     * 商户号
     * 银行入驻抖音支付商家平台分配的商户号(当前线下提供)
     * 示例值:1230000109
     */
    private String mchId;

    /**
     * 应用 id
     * 入驻抖音开放平台时分配的应用id。加密手机号发券模式下无需传该参数
     * 示例值:wxd678efh567hg6787
     *
     */
    private String appId;

    /**
     * 访问 token
     * 通过授权码获取到的access token。加密手机号发券模式下无需传该参数
     * 示例值:qswxd678efh5
     */
    private String accessToken;

    /**
     * 用户权限范围
     * 用户授权后，获取到的操作权限范围，用于发用户券鉴权，加密手机号发券模式下无需传该参数
     * 示例值:abc123
     */
    private String scope;

    /**
     * 用户身份类型
     * 目前仅加密手机号发券时需传入
     * encrypt_phone
     */
    private String identityType;
}
