package cn.com.duiba.supplier.channel.service.api.dto.response;

import cn.com.duiba.supplier.channel.service.api.enums.order.ChannelOrderStatusEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 通用直冲回调记录
 * @author kjj mybatis generator 
 * @date 2024-01-26
 */
@Data
public class CommonZcCallbackDto implements Serializable {

    private static final long serialVersionUID = 7318021539762640631L;

    /**
     * 客户订单号
     */
    private String customerOrderNo;

    /**
     * 订单号
     */
    private String orderNo;

    /**
     * 返回的券ID
     */
    private String couponId;

    /**
     * 核销时间
     */
    private Date consumeTime;

    /**
     * 券状态
     * @see ChannelOrderStatusEnum
     */
    private String couponStatus;

    /**
     * 失效时间
     */
    private String expiredTime;

    /**
     * 失效原因
     */
    private String expiredReason;

    /**
     * 回调数据json
     */
    private String callbackInfo;

    /**
     * 核销订单号
     */
    private String useOrderNo;

    /**
     * 核销门店信息
     */
    private String useStoreInfo;
}