package cn.com.duiba.supplier.channel.service.api.remoteservice.alipay.transfer;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.supplier.channel.service.api.dto.request.BaseReq;
import cn.com.duiba.supplier.channel.service.api.dto.request.alipay.transfer.AlipayB2CTransferReq;
import cn.com.duiba.supplier.channel.service.api.dto.response.BaseResp;
import cn.com.duiba.supplier.channel.service.api.dto.response.BaseResultResp;
import cn.com.duiba.supplier.channel.service.api.dto.response.alipay.transfer.AlipayB2CTransferResp;

/**
 * 支付宝B2C转账远程服务接口
 *
 * @author yangyukang
 * @since 2024/12/26
 */
@AdvancedFeignClient
public interface RemoteAlipayB2CTransferService {

    /**
     * 支付宝B2C转账分发
     *
     * @param request 转账请求
     * @return 分发结果
     */
    BaseResp distribute(BaseReq<AlipayB2CTransferReq> request);

    /**
     * 查询支付宝B2C转账结果
     *
     * @param bizType 业务类型
     * @param bizNo   业务单号
     * @return 转账结果
     */
    BaseResultResp<AlipayB2CTransferResp> distributeResult(Integer bizType, String bizNo);
} 