package cn.com.duiba.supplier.channel.service.api.remoteservice.jd;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.supplier.channel.service.api.dto.request.BaseReq;
import cn.com.duiba.supplier.channel.service.api.dto.request.jd.JdWaiMaiZcReq;
import cn.com.duiba.supplier.channel.service.api.dto.request.jd.JdWaiMaiZcSmsSendReq;
import cn.com.duiba.supplier.channel.service.api.dto.response.BaseResp;
import cn.com.duiba.supplier.channel.service.api.dto.response.BaseResultResp;
import cn.com.duiba.supplier.channel.service.api.dto.response.jd.JdSmsResp;
import cn.com.duiba.supplier.channel.service.api.dto.response.jd.JdWaiMaiZcResp;
import cn.com.duiba.supplier.channel.service.api.dto.response.jd.JdWaiMaiZcSmsCodeResp;
import cn.com.duiba.supplier.channel.service.api.enums.order.BizTypeEnum;

/**
 * 京东外卖直充远程服务接口
 *
 * @author yangyukang
 * @since 2024/12/19
 */
@AdvancedFeignClient
public interface RemoteJdWaiMaiZcService {

    /**
     * 发放
     * 注意：若结果以mq回调，业务方需要根据业务类型+业务单号幂等<br/>
     * 长时间收不到回调调用查询接口查询<br/>
     *
     * @param request 发放请求参数
     * @return 本次请求是否成功
     */
    BaseResp distribute(BaseReq<JdWaiMaiZcReq> request);

    /**
     * 查询发放结果
     *
     * @param bizType 业务类型
     *                {@link BizTypeEnum}
     * @param bizNo   业务方唯一单号
     * @return 发放结果
     */
    BaseResultResp<JdWaiMaiZcResp> distributeResult(Integer bizType, String bizNo);

    /**
     * 触发供应商发送验证码
     *
     * @param mobile 手机号
     * @return 结果
     */
    JdSmsResp send(String mobile) throws BizException;

    /**
     * 京东外卖发送验证码
     * @param req 请求参数
     * @return 响应结果
     */
    JdWaiMaiZcSmsCodeResp smsSend(JdWaiMaiZcSmsSendReq req);

    /**
     * 第三方通知结果
     *
     * @param body 通知消息体
     * @return 是否处理成功
     */
    boolean notify(String body);
} 