package cn.com.duiba.supplier.channel.service.api.remoteservice.xunleivip;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.supplier.channel.service.api.dto.request.BaseReq;
import cn.com.duiba.supplier.channel.service.api.dto.request.tenxunvideovip.TeZhenTencentVideoVipZcReq;
import cn.com.duiba.supplier.channel.service.api.dto.request.xunleivip.TeZhenXunLeiVipZcReq;
import cn.com.duiba.supplier.channel.service.api.dto.response.BaseResp;
import cn.com.duiba.supplier.channel.service.api.dto.response.BaseResultResp;
import cn.com.duiba.supplier.channel.service.api.dto.response.tenxunvideovip.TeZhenTencentVideoVipZcResp;
import cn.com.duiba.supplier.channel.service.api.dto.response.xunleivip.TeZhenXunLeiVipZcResp;
import cn.com.duiba.supplier.channel.service.api.enums.order.BizTypeEnum;

/**
 * 特祯-迅雷会员RPC
 *
 * @author xuzhigang
 * @date 2025/1/14 13:58
 **/
@AdvancedFeignClient
public interface RemoteTeZhenXunLeiVipZcService {

    /**
     * 发放
     * 注意：若结果以mq回调，业务方需要根据业务类型+业务单号幂等<br/>
     * 长时间收不到回调调用查询接口查询<br/>
     *
     * @param request 发放请求参数
     * @return 本次请求是否成功
     */
    BaseResp distribute(BaseReq<TeZhenXunLeiVipZcReq> request);

    /**
     * 查询发放结果
     *
     * @param bizType 业务类型
     *                {@link BizTypeEnum}
     * @param bizNo   业务方唯一单号
     * @return 发放结果
     */
    BaseResultResp<TeZhenXunLeiVipZcResp> distributeResult(Integer bizType, String bizNo);

    /**
     * 第三方通知结果
     *
     * @param body 通知消息体
     * @return 是否处理成功
     */
    boolean notify(String body);

}
